	subroutine READIN(iout, idbg, Ne, Nn, Nb, Nm, Np, Ng, Ns, NnNd, ldw, &
			Sx, Kappa, tc, aopt, tmax, dt, dto, Nt, theta, theta1, ie, &
			x, C, V, D, par, xg, wg, BCe, BCi, BCvalue, BCtype, Soe, por, &
			vA, vL, vB, vQc1, vQd1, vF1, ipar, fpar, maxit, Ctol, &
			rA, rL, rB, rQc1, rQd1, rF1, &
			cA, cL, cB, cQc1, cQd1, cF1, &
			lastA, lastL, lastB, lastQc1, lastQd1, lastF1)
! read input

	implicit none
	integer iout, idbg
	integer Ne, Nn, Nb, Nm, Np, Ng, Ns, NnNd, ldw	! array parameters
	integer lastA, lastL, lastB, lastQc1, lastQd1, lastF1
	integer Nt				! number of time increments
	integer maxit
	real*8 Sx, Kappa, tc, aopt, por
	real*8 tmax, dt, dto
	real*8 theta, theta1, Ctol
	integer ipar(16)			! bCGstab integer parameters array
	real*8 fpar(16)				! bCGstab real    parameters array
	integer BCe(Nb,2), BCi(Nb)		! BC element and local element face numbers
	integer rA (Nn+1), rL (Nn+1), rB(Nn+1)	! global  arrays (compact rows)
	integer cA (NnNd), cL (NnNd), cB(NnNd)	! global  arrays (compact columns)
	integer rQc1(Nn+1), rQd1(Nn+1), rF1(Nn+1)	! global  arrays (compact rows)
	integer cQc1(NnNd), cQd1(NnNd), cF1(NnNd)	! global  arrays (compact columns)
	real*8 BCvalue(Nb,Ns,1)			! BC value (jx_bar, qx_bar or c_bar)
	character*1 BCtype(Nb)			! BC type ('R', 'N' or 'D')
	integer ie(Ne,3)			! global connectivity array
	real*8 x(Nn,1)				! global coordinates array
	real*8 Soe(Ne,Ns,2)			! element independent source nodal values
	real*8 V(Ne,1), D(Ne,1,1)		! global  arrays
	real*8 C   (Nn,Ns)			! global  arrays
	real*8 vA (NnNd ), vL (NnNd ), vB(NnNd)	! global  arrays (compact values)
	real*8 vQc1(NnNd), vQd1(NnNd), vF1(NnNd)! global  arrays (compact values)
	real*8 par(0:Np,2,Nm)			! M(t) parameters
	real*8 xg(Ng), wg(Ng)			! Gauss abscissas [-1,+1] and weights

	integer i, e, m, p, s, ierror, i1, i2
	real*8 Peclet, h, Vabs, Dabs	! cell Pe, size, |Vi|, |Dik|
	real*8 CFLc, CFLd, CFLcmax, CFLdmax, Pecletmax

	data ierror /0/, CFLcmax/-1.d12/, CFLdmax/-1.d12/, Pecletmax/-1.d12/
!	write(idbg,'(a)') ' --- READIN ---'	! ### TEMPORARY ###

! read input from inp.txt
	read (1,*) Sx, Kappa, tc, por		! properties
	read (1,*) tmax, dt, dto
	read (1,*) theta			! temporal scheme parameter
	read (1,*) ipar(2), ipar(3), ipar(6)	! arguments needed to biCGstab
	read (1,*) fpar(1), fpar(2), fpar(11)	! arguments needed to biCGstab
	read (1,*) maxit, Ctol			! implicit BC and source convergence parameters
	close(1)

	ipar(1) = 0				! initialize bCGstab
	ipar(4) = ldw				! work array dimension for bCGstab
	ipar(5) = 0				! unused for bCGstab
	Nt = nint( tmax / dt )
	theta1 = 1.d0 - theta

! reset all global arrays (ARRAY ASSIGNMENT)
	vA   = 0.
	vL   = 0.
	vB   = 0.
	vQc1 = 0.
	vQd1 = 0.
	vF1  = 0.
	rA   = 1
	rL   = 1
	rB   = 1
	rQc1 = 1
	rQd1 = 1
	rF1  = 1
	cA   = 0
	cL   = 0
	cB   = 0
	cQc1 = 0
	cQd1 = 0
	cF1  = 0
! reset last indices for the sparse arrays
	lastA   = 0
	lastL   = 0
	lastB   = 0
	lastQc1 = 0
	lastQd1 = 0
	lastF1  = 0

! read element connectivity form elements.txt
	open(1, file='elements.txt', status='old')
	do e = 1, Ne
	  read (1,*) i, (ie(e,m), m=1,3)	! element node 1, node 2, mat
	enddo		! e
	close(1)

! read Darcian flux data from V.txt
	open(1, file='V.txt', status='old')
	do e = 1, Ne
	  read (1,*) m, (V(e,i), i=1,1)		! Vx
	enddo		! e
	close(1)
	V = V/por				! change from Darcian flux to velocity

! read dispersion data from D.txt
	open(1, file='D.txt', status='old')
	do e = 1, Ne
	  read (1,*) m, ((D(e,i,p), i=1,1), p=1,1)	! Dxx
	enddo		! e
	close(1)

! for EXP only: read M(t) parameters
! read material data from materials.txt
	if(Np .ne. 0)	then
	  open(1, file='materials.txt', status='old')
	  do m = 1, Nm
	    read (1,*) par(0,1,m)		! Ao
	    par(0,2,m) = 0.			! Bo=0
	    do p = 1, Np
	      read (1,*) par(p,1,m), par(p,2,m)	! M(t) parameters
	    enddo	! p
	  enddo		! m
	endif
	close(1)

! read nodes data from nodes.txt
	open(1, file='nodes.txt', status='old')
! nodal coordinates & IC
	do i = 1, Nn
	  read (1,*) m, x(i,1), (C(i,s), s=1, Ns)
	enddo		! i
	close(1)

! read element face BC data from BCs.txt
	open(1, file='BCs.txt', status='old')
! BC element, BC face, BC type and 2 BC values at the BC element face nodes
	do i = 1, Nb
	  read (1,*) BCi(i), BCe(i,2), BCtype(i), ((BCvalue(i,s,m), m=1,1), s=1,Ns)
	enddo		! i
	close(1)

! read element independent source data from source.txt
	open(1, file='source.txt', status='old')
! 4 independent source values at the element nodes
	do e = 1, Ne
	  do s = 1, Ns
	    read (1,*) m, p, Soe(e,s,1), Soe(e,s,2)
	  enddo		! s
	enddo		! e
	close(1)

	xg(2) = sqrt(1./3.d0)	! #### TEMPORARILY assume Ng = 2
	xg(1) = -xg(2)
	wg(1) = 1.d0
	wg(2) = 1.d0
! --------------------------------- ECHO INPUT ---------------------------------
	write(iout,*) 'Sx, Kappa, tc, por = ', Sx, Kappa, tc, por
	write(iout,*) 'tmax, dt, dto, Nt'
	write(iout,*)  tmax, dt, dto, Nt
	write(iout,*) 'theta= ', theta
	write(iout,*) 'ipar = ', ipar
	write(iout,*) 'fpar = ', fpar
	write(iout,*) 'maxit, Ctol =', maxit, Ctol

	write(iout,*)  'i, xg(i), wg(i)'
	do i = 1, Ng
	  write(iout,*) i, xg(i), wg(i)
	enddo		! i

! the stability criteria for explicit scheme are:
! o v*dt/h   <1    (advection)
! o D*dt/h^2 < 0.5 (dispersion)
! assume V = |Vi|, D = |Dik|
	do e = 1, Ne
	  i1 = ie(e,1)				! 1st node
	  i2 = ie(e,2)				! 2nd node
	  h = abs( x(i2,1)-x(i1,1) )		! element size
	  Vabs = abs( V(e,1) )			! |Vi|
	  Dabs = abs( D(e,1,1) )		! |Dik|
	  Peclet = 0.5d0 * Vabs * h / Dabs	! Pe
	  CFLc = Vabs*dt/h			! advection  CFL
	  CFLd = Dabs*dt/h**2			! dispersion CFL
	  if(CFLc   .gt. CFLcmax)	CFLcmax = CFLc
	  if(CFLd   .gt. CFLdmax)	CFLdmax = CFLd
	  if(Peclet .gt. Pecletmax)	Pecletmax = Peclet
	enddo		! e

! calculate aopt = ctgh(|Pe|) - 1/|Pe| where Pe = (|Vi|*h) / (2*D) (half of my Pe_h !!!)
	Peclet = Pecletmax
	aopt = ( exp(Peclet) + exp(-Peclet) ) / ( exp(Peclet) - exp(-Peclet) ) - 1./Peclet
	if(Pecletmax .le. 1.  ) aopt = 0.				! SUPG not needed
	if(Pecletmax .ge. 700.) aopt = 1.				! saturation reached

	write(iout,*)  'maximum advection   CFL (Vabs * dt / h)       = ', CFLcmax
	write(iout,*)  'maximum dispersion  CFL (Dabs * dt / h**2)    = ', CFLdmax
	write(iout,*)  'maximum Peclet number (0.5 * Vabs * h / Dabs) = ', Pecletmax
	write(iout,*)  'SUPG parameter, aopt = ', aopt
! --------------------------------- ECHO INPUT ---------------------------------

	open(11  , file=  'fx.txt', status='unknown')
	write(11,*) 'i, x(i)'
	do i = 1, Nn
	  write(11,*)  i, x(i,1)			! output x
	enddo	! i
	close(11)

! check general input
	if(por .le. 0. .or. por .gt. 1.) then
	  write(iout,*) '*** ABORT: porosity is not between 0 and 1'
	  ierror = ierror + 1
	endif
	if(Sx .le. 0. .or. tc .le. 0.) then
	  write(iout,*) '*** ABORT: Sx, or tc .le. 0'
	  ierror = ierror + 1
	endif
	if(Kappa .lt. 0.) then
	  write(iout,*) '*** ABORT: Kappa < 0'
	  ierror = ierror + 1
	endif
	if(Kappa .gt. 0. .and. Ns .ne. 3) then
	  write(iout,*) '*** ABORT: for Kappa>0 Ns must be 3'
	  ierror = ierror + 1
	endif
	if(dt .le. 0. .or. dto .le. 0.) then
	  write(iout,*) '*** ABORT: dt .le. 0 or dto .le. 0'
	  ierror = ierror + 1
	endif
	if(Nt .lt. 0) then
	  write(iout,*) '*** ABORT: Nt .lt. 0'
	  ierror = ierror + 1
	endif
	if(Ng .ne. 2) then
	  write(iout,*) '*** ABORT: only Ng = 2 is currently allowed for'
	  ierror = ierror + 1
	endif
	if(theta .lt. 0. .or. theta .gt. 1.) then
	  write(iout,*) '*** ABORT: theta <0 or theta>1'
	  ierror = ierror + 1
	endif
	if(fpar(1) .le. 0. .or. fpar(2) .le. 0.) then
	  write(iout,*) '*** ABORT: fpar(1) .le. 0. .or. fpar(2) .le. 0.'
	  ierror = ierror + 1
	endif
	if(ipar(2) .lt. 0 .or. ipar(2) .gt. 3) then
	  write(iout,*) '*** ABORT: ipar(2) .lt. 0 .or. ipar(2) .gt. 3'
	  ierror = ierror + 1
	endif
	if(ipar(3) .lt. -2 .or. ipar(2) .gt. 2) then
	  write(iout,*) '*** ABORT: ipar(3) .lt. -2 .or. ipar(2) .gt. 2'
	  ierror = ierror + 1
	endif
! check element input
	do e = 1, Ne
	  if(ie(e,1) .lt. 1 .or. ie(e,1) .gt. Nn .or. &
	     ie(e,2) .lt. 1 .or. ie(e,2) .gt. Nn .or. &
	     ie(e,3) .lt. 1 .or. ie(e,3) .gt. Nm ) then
	    write(iout,*) '*** ABORT: illegal ie(e,*), e, ie(e,*) = ', &
						       e, (ie(e,m), m=1,3)
	    ierror = ierror + 1
	  endif
	enddo		! e
	do e = 1, Ne
	  if(D(e,1,1).lt.0. ) then
	    write(iout,*) '*** ABORT: D(e,i,j)<0 for e = ', e
	    ierror = ierror + 1
	  endif
	enddo		! e
! check material input
	if(Np .ne. 0)	then
	  do m = 1, Nm
	    do p = 0, Np
	      if(par(p,1,m) .eq. 0. .or. par(p,2,m) .lt. 0.) then
	        write(iout,*) '*** ABORT: illegal par(p,*,m), m, p = ', m, p
	        ierror = ierror + 1
	      endif
	    enddo	! p
	  enddo		! m
	endif
! check BCs input
	do i = 1, Nb
	  if(BCe(i,2) .lt. 1 .or. BCe(i,2) .gt. Ne) then
	    write(iout,*) '*** ABORT: illegal BCe'
	    ierror = ierror + 1
	  endif
	  if(BCi(i) .lt. 1 .or. BCi(i) .gt. 4) then
	    write(iout,*) '*** ABORT: illegal BCi'
	    ierror = ierror + 1
	  endif
	  if( BCtype(i).ne.'R' .and. BCtype(i).ne.'N' .and. BCtype(i).ne.'D') then
	    write(iout,*) '*** ABORT: illegal i, BCtype(i) = ', i, BCtype(i)
	    ierror = ierror + 1
	  endif
	enddo		! i

	if(ierror .ne. 0) then
	  write(iout,*) '*** ABORT: ierror = ', ierror
	  stop
	endif
	
	return
	end
